package jp.veltec.pdf;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.PageSize;

public class Util{

	/**
	* mmまたはptで指定されたサイズをPdfBuilderで扱うサイズの形式に変換します。
	* @param size サイズを表す文字列（mmまたはpt）
	*/
	public static float getSize(String size) throws IllegalArgumentException{
		if(size.endsWith("mm")){
			size=size.substring(0,size.length()-2);
			return 72f/25.4f*(Float.parseFloat(size));
		}else if(size.endsWith("pt")){
			size=size.substring(0,size.length()-2);
			return Float.parseFloat(size);
		}else{
			throw new IllegalArgumentException("size format error:"+ size);
		}
	}

	/**
	* 用紙サイズを取得します。
	* @param aPageSize A3,A3L,A4,A4L,A5,A5L,A6,B4,B4L,B5,B5L,B6,B6L,PostCard,PostCardL
	*/
	public static Rectangle getStandardSize(String aPageSize){
		Rectangle mSize = null;
		if(aPageSize.equals("A3")){
				float x = getSize("297mm");
				float y = getSize("420mm");
				mSize = new Rectangle(x,y);
		}else if(aPageSize.equals("A3L")){
				float x = getSize("420mm");
				float y = getSize("297mm");
				mSize = new Rectangle(x,y);
		}else if(aPageSize.equals("A4")){
				float x = getSize("210mm");
				float y = getSize("297mm");
				mSize = new Rectangle(x,y);
		}else if(aPageSize.equals("A4L")){
				float x = getSize("297mm");
				float y = getSize("210mm");
				mSize = new Rectangle(x,y);
		}else if(aPageSize.equals("A5")){
				float x = getSize("148mm");
				float y = getSize("210mm");
				mSize = new Rectangle(x,y);
		}else if(aPageSize.equals("A5L")){
				float x = getSize("210mm");
				float y = getSize("148mm");
				mSize = new Rectangle(x,y);
		}else if(aPageSize.equals("A6")){
				float x = getSize("105mm");
				float y = getSize("148mm");
				mSize = new Rectangle(x,y);
		}else if(aPageSize.equals("A6L")){
				float x = getSize("148mm");
				float y = getSize("105mm");
				mSize = new Rectangle(x,y);
		}else if(aPageSize.equals("B4")){
				float x = getSize("257mm");
				float y = getSize("364mm");
				mSize = new Rectangle(x,y);
		}else if(aPageSize.equals("B4L")){
				float x = getSize("364mm");
				float y = getSize("257mm");
				mSize = new Rectangle(x,y);
		}else if(aPageSize.equals("B5")){
				float x = getSize("182mm");
				float y = getSize("257mm");
				mSize = new Rectangle(x,y);
		}else if(aPageSize.equals("B5L")){
				float x = getSize("257mm");
				float y = getSize("182mm");
				mSize = new Rectangle(x,y);
		}else if(aPageSize.equals("B6")){
				float x = getSize("128mm");
				float y = getSize("182mm");
				mSize = new Rectangle(x,y);
		}else if(aPageSize.equals("B6L")){
				float x = getSize("182mm");
				float y = getSize("128mm");
				mSize = new Rectangle(x,y);
		}else if(aPageSize.equals("PostCard")){
				float x = getSize("100mm");
				float y = getSize("148mm");
				mSize = new Rectangle(x,y);
		}else if(aPageSize.equals("PostCardL")){
				float x = getSize("148mm");
				float y = getSize("100mm");
				mSize = new Rectangle(x,y);
		}else{
			throw new IllegalArgumentException("not supported document size:" + aPageSize);
		}
		return mSize;
	}

	/**
	* 色名を値に変換します。
	* @param color white,black,gray,red,green,blue,yellow,#000000～#FFFFFF
	*/
	public static BaseColor getColor(String color){
		if(color.equals("white")){
			color="#FFFFFF";
		}else if(color.equals("black")){
			color="#000000";
		}else if(color.equals("gray")){
			color="#808080";
		}else if(color.equals("red")){
			color="#FF0000";
		}else if(color.equals("green")){
			color="#00FF00";
		}else if(color.equals("blue")){
			color="#0000FF";
		}else if(color.equals("yellow")){
			color="#FFFF00";
		}
		try{
			int r =Integer.valueOf(color.substring(1,3),16);
			int g =Integer.valueOf(color.substring(3,5),16);
			int b =Integer.valueOf(color.substring(5,7),16);
			return new BaseColor(r,g,b);
		}catch(NumberFormatException e){
			throw new IllegalArgumentException("not supported color:" + color);
		}
	}

}