package jp.veltec.pdf;

import java.util.Map;
import java.util.HashMap;
import java.util.ArrayList;
import java.io.File;
import java.io.OutputStream;
import java.io.IOException;
import org.w3c.dom.NodeList;
import org.w3c.dom.Node;
import org.w3c.dom.NamedNodeMap;

import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.Font;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.Element;

import java.net.MalformedURLException;

/**
*1ページに複数の表を含む帳票を作成します。
*/
public class TableLayout extends PdfLayout{

	HashMap<String,String> fTableDefault;
	HashMap<String,String> fRowDefault;

	public TableLayout(OutputStream aOutputStream){
		super(aOutputStream);
	}

	void process(HashMap<String,String> aData) throws DocumentException{
		NodeList tables = fTemplate.getElementsByTagName("table");
		ArrayList<String> mIdList = new ArrayList<String>();
		for(int tableCount=0;tableCount<tables.getLength();tableCount++){
			org.w3c.dom.Element xmlTable = (org.w3c.dom.Element)tables.item(tableCount);
			String strCols = xmlTable.getAttribute("cols");
			if(strCols.equals("")){
				throw new IllegalStateException("cols not specified");
			}
			int cols = Integer.parseInt(strCols);
			PdfPTable pdfTable = new PdfPTable(cols);

			float outerBorderWidth = Util.getSize("0.2mm");
			float innerBorderWidth = Util.getSize("0.2mm");
			String attribute;
			attribute=xmlTable.getAttribute("outer-border-width");
			if(!attribute.equals("")){
				DrawOuterBorder outerBorder = new DrawOuterBorder();
				outerBorder.setBorderWidth(Util.getSize(attribute));
				pdfTable.setTableEvent(outerBorder);
			}
			attribute=xmlTable.getAttribute("margin-top");
			if(!attribute.equals("")){
				pdfTable.setSpacingBefore(Util.getSize(attribute));
			}
			attribute=xmlTable.getAttribute("margin-bottom");
			if(!attribute.equals("")){
				pdfTable.setSpacingAfter(Util.getSize(attribute));
			}else{
				pdfTable.setSpacingAfter(Util.getSize("5mm"));
			}
			attribute=xmlTable.getAttribute("table-align");
			if(!attribute.equals("")){
				if(attribute.equals("left")){
					pdfTable.setHorizontalAlignment(0);
				}else if(attribute.equals("center")){
					pdfTable.setHorizontalAlignment(1);
				}else if(attribute.equals("right")){
					pdfTable.setHorizontalAlignment(2);
				}else{
					throw new IllegalArgumentException("bad table-align:" + attribute);
				}
			}
			pdfTable.setLockedWidth(true);
			float totalWidth=0;
			attribute=xmlTable.getAttribute("widths");
			if(!attribute.equals("")){
				String[] strWidths = attribute.split(" ");
				float[] widths = new float[strWidths.length];
				for(int j=0;j<strWidths.length;j++){
					widths[j]=Util.getSize(strWidths[j]);
					totalWidth += widths[j];
				}
				pdfTable.setWidths(widths);
			}
			if(totalWidth==0){
				pdfTable.setTotalWidth(fDocument.getPageSize().getWidth()-fDocument.leftMargin()-fDocument.rightMargin());
			}else{
				pdfTable.setTotalWidth(totalWidth);
			}
			fTableDefault = new HashMap<String,String>();
			NamedNodeMap mapT = xmlTable.getAttributes();
			for(int i=0;i<mapT.getLength();i++){
				Node node = mapT.item(i);
				fTableDefault.put(node.getNodeName(),node.getNodeValue());
			}

			NodeList trs = xmlTable.getElementsByTagName("tr");
			int rows=trs.getLength();
			for(int rowCounter=0;rowCounter<rows;rowCounter++){
				org.w3c.dom.Element tr = (org.w3c.dom.Element)trs.item(rowCounter);
				fRowDefault = new HashMap<String,String>();
				NamedNodeMap mapR = tr.getAttributes();
				for(int i=0;i<mapR.getLength();i++){
					Node nodeR = mapR.item(i);
					fRowDefault.put(nodeR.getNodeName(),nodeR.getNodeValue());
				}
				NodeList tds = tr.getElementsByTagName("td");
				for(int k=0;k<tds.getLength();k++){
					org.w3c.dom.Element td = (org.w3c.dom.Element)tds.item(k);
					String mContent = td.getTextContent();
					String mId = td.getAttribute("id");
					if(!mId.equals("")){
						mIdList.add(mId);
						String mValue = aData.get(mId);
						if(mValue!=null){
							mContent = mValue;
						}
						HashMap<String,String> mExtraAttributes = fExtraAttributes.get(mId);
						if(mExtraAttributes!=null){
							for(Map.Entry<String,String> entry:mExtraAttributes.entrySet()){
								td.setAttribute(entry.getKey(),entry.getValue());
							}
						}
					}
					Cell cell = new Cell();
					cell.setTableDefault(fTableDefault);
					cell.setRowDefault(fRowDefault);
					String strColspan = td.getAttribute("colspan");
					int colspan = 1;
					if(!strColspan.equals("")){
						colspan = Integer.parseInt(strColspan);
						cell.setColspan(colspan);
					}
					int rowspan = 1;
					String strRowspan = td.getAttribute("rowspan");
					if(!strRowspan.equals("")){
						rowspan = Integer.parseInt(strRowspan);
						cell.setRowspan(rowspan);
					}

					cell.setAttributes(td);
					cell.setContent(mContent);
					pdfTable.addCell(cell);
				}
			}
			attribute=xmlTable.getAttribute("position");
			if(attribute.equals("absolute")){
				if(xmlTable.getAttribute("left").equals("") ||xmlTable.getAttribute("top").equals("")){
					throw new IllegalArgumentException("left and top must be set for absolute position table");
				}
				float x=(Util.getSize(xmlTable.getAttribute("left")));
				float y=(fDocument.getPageSize().getHeight()-Util.getSize(xmlTable.getAttribute("top")));
				pdfTable.writeSelectedRows(0,-1,x,y,fDirectContent);
			}else{
				fDocument.add(pdfTable);
			}
		}

		for(String key:aData.keySet()){
			if(!mIdList.contains(key)){
				throw new IllegalArgumentException("id not found:" + key);
			}
		}
	}

}
