package jp.veltec.pdf;

import java.io.OutputStream;
import java.io.IOException;
import java.io.File;
import java.util.Map;
import java.util.HashMap;
import java.util.ArrayList;
import java.net.MalformedURLException;
import org.w3c.dom.NodeList;
import org.w3c.dom.Node;
import org.w3c.dom.NamedNodeMap;

import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.pdf.VerticalText;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.ColumnText;
import com.itextpdf.text.Font;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.BaseColor;

/**
*1ページに複数の段落を含む帳票を作成します。
*/
public class ParagraphLayout extends PdfLayout{


	public ParagraphLayout(OutputStream aOutputStream){
		super(aOutputStream);
	}

    void process(HashMap<String,String> aData)throws DocumentException{
		NodeList listP = fTemplate.getElementsByTagName("p");
		ArrayList<String> mIdList = new ArrayList<String>();
		for(int i=0;i<listP.getLength();i++){
			org.w3c.dom.Element elementP = (org.w3c.dom.Element)listP.item(i);
			float fontSize=12;
			int alignment=0;
			//float rotation=0;
			float characterSpacing=0;
			float lineSpacing=-1;
			float spacingBefore=0;
			float spacingAfter=0;

			//set content
			String mContent = elementP.getTextContent().replaceAll("\\n\t+","");
			String mId = elementP.getAttribute("id");
			if(!mId.equals("")){
				mIdList.add(mId);
				String mValue = aData.get(mId);
				if(mValue!=null){
					mContent=mValue;
				}
				HashMap<String,String> mExtraAttributes = fExtraAttributes.get(mId);
				if(mExtraAttributes!=null){
					for(Map.Entry<String,String> entry:mExtraAttributes.entrySet()){
						elementP.setAttribute(entry.getKey(),entry.getValue());
					}
				}
			}


			//font-familly
			String mAttribute = elementP.getAttribute("font-family");
			String mFontFamily = "default";
			if(!mAttribute.equals("")){
				mFontFamily=mAttribute;
			}

			//font-size
			mAttribute = elementP.getAttribute("font-size");
			if(!mAttribute.equals("")){
				fontSize = Util.getSize(mAttribute);
			}

			//holizontal align
			mAttribute = elementP.getAttribute("align-h");
			if(mAttribute.equals("center")){
				alignment=1;
			}else if(mAttribute.equals("right")){
				alignment=2;
			}else{
				alignment=0;
			}

			//mAttribute = elementP.getAttribute("rotation");
			//if(!mAttribute.equals("")){
			//	try{
			//		rotation=Float.parseFloat(mAttribute);
			//	}catch(NumberFormatException e){
			//		throw new IllegalArgumentException("illegal rotation:" +mAttribute );
			//	}
			//}

			mAttribute = elementP.getAttribute("character-spacing");
			if(!mAttribute.equals("")){
				characterSpacing=Util.getSize(mAttribute);
			}

			mAttribute = elementP.getAttribute("line-spacing");
			if(!mAttribute.equals("")){
				lineSpacing=Util.getSize(mAttribute)+fontSize;
			}else{
				lineSpacing=fontSize*1.5f;
			}

			mAttribute = elementP.getAttribute("margin-top");
			if(!mAttribute.equals("")){
				spacingBefore=Util.getSize(mAttribute);
			}

			mAttribute = elementP.getAttribute("margin-bottom");
			if(!mAttribute.equals("")){
				spacingAfter=Util.getSize(mAttribute);
			}

			BaseColor mFontColor=BaseColor.BLACK;
			mAttribute = elementP.getAttribute("font-color");
			if(!mAttribute.equals("")){
				mFontColor=Util.getColor(mAttribute);
			}

			int mFontStyle=Font.NORMAL;
			mAttribute = elementP.getAttribute("font-style");
			if(!mAttribute.equals("")){
				if(mAttribute.equals("normal")){
					mFontStyle=Font.NORMAL;
				}else if(mAttribute.equals("bold")){
					mFontStyle=Font.BOLD;
				}else if(mAttribute.equals("italic")){
					mFontStyle=Font.ITALIC;
				}else if(mAttribute.equals("bold-italic")){
					mFontStyle=Font.BOLDITALIC ;
				}else{
					throw new IllegalArgumentException("not supported font-style:" + mAttribute);
				}
			}

			boolean isAbsolutePosition = false;
			mAttribute = elementP.getAttribute("position");
			if(mAttribute.equals("absolute")){
				isAbsolutePosition=true;
			}
			if(isAbsolutePosition){
				float mTop = 0;
				float mLeft = fDocument.leftMargin();
				mAttribute = elementP.getAttribute("top");
				if(!mAttribute.equals("")){
					mTop=fDocument.getPageSize().getHeight()-Util.getSize(mAttribute);
				}
				mAttribute = elementP.getAttribute("left");
				if(!mAttribute.equals("")){
					mLeft=Util.getSize(mAttribute);
				}
				float mWidth = fDocument.getPageSize().getWidth()-mLeft-fDocument.rightMargin();
				mAttribute = elementP.getAttribute("vertical");
				if(mAttribute.equals("true")){
					BaseFont bf = FontManager.getBaseFontV(mFontFamily);
					Font font = new Font(bf,fontSize);
					font.setColor(mFontColor);
					font.setStyle(mFontStyle);
					float mHeight = mTop;
					mAttribute=elementP.getAttribute("height");
					if(!mAttribute.equals("")){
						mHeight=Util.getSize(mAttribute);
					}
					VerticalText vText = new VerticalText(fDirectContent);
					vText.setOrigin(mLeft,mTop);
					vText.setHeight(mHeight);
					vText.setMaxLines(100);
					vText.setLeading(lineSpacing);
					//vText.setAlignment(alignment);
					Chunk chunk = new Chunk(mContent,font);
					//chunk.setCharacterSpacing(characterSpacing*-1);
					vText.addText(chunk);
					vText.go();
				}else{
					//float mHeight=fDocument.getPageSize().getHeight()-mTop;
					mAttribute = elementP.getAttribute("width");
					if(!mAttribute.equals("")){
						mWidth=Util.getSize(mAttribute);
					}
					float mHeight=mTop;
					mAttribute = elementP.getAttribute("height");
					if(!mAttribute.equals("")){
						mHeight=Util.getSize(mAttribute);
					}
					BaseFont bf = FontManager.getBaseFont(mFontFamily);
					Font font = new Font(bf,fontSize);
					font.setColor(mFontColor);
					font.setStyle(mFontStyle);
					Chunk chunk = new Chunk(mContent,font);
					chunk.setCharacterSpacing(characterSpacing);
					ColumnText ct = new ColumnText(fDirectContent);
					ct.setAlignment(alignment);
					ct.addText(chunk);
					ct.setSimpleColumn(mLeft,mTop-mHeight,mLeft+mWidth,mTop);
					if(lineSpacing!=-1){
						ct.setLeading(lineSpacing);
					}
					ct.go();
				}
			}else{
				BaseFont bf = FontManager.getBaseFont(mFontFamily);
				Font font = new Font(bf,fontSize);
				font.setColor(mFontColor);
				font.setStyle(mFontStyle);
				Chunk chunk = new Chunk(mContent,font);
				chunk.setCharacterSpacing(characterSpacing);
				Paragraph paragraph = new Paragraph(chunk);
				mAttribute = elementP.getAttribute("left-indent");
				if(!mAttribute.equals("")){
					paragraph.setIndentationLeft(Util.getSize(mAttribute));
				}
				mAttribute = elementP.getAttribute("right-indent");
				if(!mAttribute.equals("")){
					paragraph.setIndentationRight(Util.getSize(mAttribute));
				}
				paragraph.setAlignment(alignment);
				paragraph.setLeading(lineSpacing);
				paragraph.setSpacingBefore(spacingBefore);
				paragraph.setSpacingAfter(spacingAfter);
				fDocument.add(paragraph);
			}
		}
		for(String key:aData.keySet()){
			if(!mIdList.contains(key)){
				throw new IllegalArgumentException("id not found:" + key);
			}
		}
    }
}
