package jp.veltec.pdf;
import java.io.IOException;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.text.pdf.PdfPageEventHelper;
import com.itextpdf.text.pdf.ColumnText;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.Font;
import com.itextpdf.text.pdf.BaseFont;

class PageHeaderWriter extends PdfPageEventHelper{
	Document fDocument = null;
	String fHeaderText = "";
	float fPositionX = 0f;
	float fPositionY = 0f;
	int fAlign = Element.ALIGN_LEFT;
	Rectangle rect = PageSize.A4;
	BaseFont fBaseFont;
	Font fFont;
	float fFontSize = 12f;
	int fFontStyle;

	public PageHeaderWriter(PdfLayout layout){
		fBaseFont = FontManager.getBaseFont("default");
		fFont = new Font(fBaseFont, fFontSize);
	}

	public PageHeaderWriter(ListTableLayout layout){
		fBaseFont = FontManager.getBaseFont("default");
		fFont = new Font(fBaseFont, fFontSize);
	}

	public void setDocument(Document aDocument){
		fDocument = aDocument;
	}

	public void setHeaderText(String aHeaderText){
		fHeaderText = aHeaderText;
	}

	public void setFontFamily(String aFontFamily){
		fBaseFont = FontManager.getBaseFont(aFontFamily);
		fFont = new Font(fBaseFont,fFontSize);
		fFont.setStyle(fFontStyle);
	}

	public void setFontSize(float aFontSize){
		fFontSize = aFontSize;
		fFont.setSize(aFontSize);
	}

	public void setFontStyle(int aFontStyle){
		fFontStyle = aFontStyle;
		fFont.setStyle(fFontStyle);
	}

	public void setPosition(float aPositionX,float aPositionY){
		fPositionX = aPositionX;
		fPositionY = aPositionY;
	}

	public void setAlign(int aAlign){
		fAlign = aAlign;
	}

	public void onStartPage(PdfWriter writer,Document document){
	}

	public void onEndPage(PdfWriter writer,Document document){
        ColumnText.showTextAligned(
			writer.getDirectContent(),
            fAlign, 
			new Phrase(fHeaderText,fFont),
            fPositionX, 
			fPositionY,
			0
		);
	}

	public void setPageLabel(org.w3c.dom.Element pageLabel){
		fHeaderText = pageLabel.getTextContent();
		float mMargin = Util.getSize("12mm");
		String mAttribute = pageLabel.getAttribute("margin");
		if(!mAttribute.equals("")){
			mMargin = Util.getSize(mAttribute);
		}
		float mPositionX=0;
		float mPositionY=0;
		int mAlign=Element.ALIGN_LEFT;
		mAttribute = pageLabel.getAttribute("position");
		if(mAttribute.equals("top-left")){
			mPositionX=mMargin;
			mPositionY=fDocument.getPageSize().getHeight()-mMargin;
		}else if(mAttribute.equals("top-center")){
			mPositionX=fDocument.getPageSize().getWidth()/2;
			mPositionY=fDocument.getPageSize().getHeight()-mMargin;
			mAlign=Element.ALIGN_CENTER;
		}else if(mAttribute.equals("top-right")||mAttribute.equals("")){
			mPositionX=fDocument.getPageSize().getWidth()-mMargin;
			mPositionY=fDocument.getPageSize().getHeight()-mMargin;
			mAlign=Element.ALIGN_RIGHT;
		}else if(mAttribute.equals("bottom-left")){
			mPositionX=mMargin;
			mPositionY=mMargin;
		}else if(mAttribute.equals("bottom-center")){
			mPositionX=fDocument.getPageSize().getWidth()/2;
			mPositionY=mMargin;
			mAlign=Element.ALIGN_CENTER;
		}else if(mAttribute.equals("bottom-right")){
			mPositionX=fDocument.getPageSize().getWidth()-mMargin;
			mPositionY=mMargin;
			mAlign=Element.ALIGN_CENTER;
		}else{
			mPositionX = Util.getSize(mAttribute.split(" ")[0]);
			mPositionY = fDocument.getPageSize().getHeight()-Util.getSize(mAttribute.split(" ")[1]);
		}
		
		setPosition(mPositionX,mPositionY);
		setAlign(mAlign);

		mAttribute = pageLabel.getAttribute("font-size");
		if(!mAttribute.equals("")){
			setFontSize(Util.getSize(mAttribute));
		}
		mAttribute = pageLabel.getAttribute("font-family");
		if(!mAttribute.equals("")){
			setFontFamily(mAttribute);
		}
		mAttribute = pageLabel.getAttribute("font-style");
			//NOP
		if(mAttribute.equals("")){
		}else if(mAttribute.equals("bold")){
			setFontStyle(1);
		}else if(mAttribute.equals("italic")){
			setFontStyle(2);
		}else if(mAttribute.equals("bold-italic")){
			setFontStyle(3);
		}else{
			throw new IllegalArgumentException("not supported font-style:" + mAttribute);
		}
	}

}
