package jp.veltec.pdf;

import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.DocumentException;
import org.w3c.dom.NodeList;
import org.w3c.dom.Node;
import java.util.HashMap;
import java.io.IOException;

class FontManager{
	static HashMap<String,BaseFont> fBaseFonts = new HashMap<String,BaseFont>();
	static HashMap<String,BaseFont> fBaseFontsV = new HashMap<String,BaseFont>();
	static String fDefaultFontPath;

	static{
		init();
	}

	static void init(){
		try{
			fBaseFonts.put("Times",BaseFont.createFont(BaseFont.TIMES_ROMAN ,BaseFont.WINANSI,BaseFont.NOT_EMBEDDED));
			fBaseFonts.put("Helvetica",BaseFont.createFont(BaseFont.HELVETICA,BaseFont.WINANSI,BaseFont.NOT_EMBEDDED));
			fBaseFonts.put("Courier",BaseFont.createFont(BaseFont.COURIER,BaseFont.WINANSI,BaseFont.NOT_EMBEDDED));
			fBaseFonts.put("Symbol",BaseFont.createFont(BaseFont.SYMBOL,BaseFont.WINANSI,BaseFont.EMBEDDED));
			fBaseFonts.put("Dingbats",BaseFont.createFont(BaseFont.ZAPFDINGBATS,BaseFont.WINANSI,BaseFont.EMBEDDED));
			fBaseFonts.put("default",BaseFont.createFont("HeiseiMin-W3","UniJIS-UCS2-H",BaseFont.NOT_EMBEDDED));
			fBaseFontsV.put("default",BaseFont.createFont("HeiseiMin-W3","UniJIS-UCS2-V",BaseFont.NOT_EMBEDDED));
			fBaseFonts.put("明朝",BaseFont.createFont("HeiseiMin-W3","UniJIS-UCS2-H",BaseFont.NOT_EMBEDDED));
			fBaseFontsV.put("明朝",BaseFont.createFont("HeiseiMin-W3","UniJIS-UCS2-V",BaseFont.NOT_EMBEDDED));
			fBaseFonts.put("ゴシック",BaseFont.createFont("HeiseiKakuGo-W5","UniJIS-UCS2-H",BaseFont.NOT_EMBEDDED));
			fBaseFontsV.put("ゴシック",BaseFont.createFont("HeiseiKakuGo-W5","UniJIS-UCS2-V",BaseFont.NOT_EMBEDDED));
		}catch(DocumentException e){
			e.printStackTrace();
		}catch(IOException e){
			e.printStackTrace();
		}
	}

	public static void clearFonts(){
		fBaseFonts.clear();
		fBaseFontsV.clear();
		init();
	}

	public static void register(NodeList listFont){
		try{
			for(int i=0;i<listFont.getLength();i++){
				org.w3c.dom.Element elementFont = (org.w3c.dom.Element)listFont.item(i);
				String mFontSpec = "";
				String mFontFamily = elementFont.getAttribute("family");
				String mFontPath = elementFont.getAttribute("path");
				boolean mEmbedded = BaseFont.EMBEDDED;
				if(!mFontPath.equals("")){
					mFontSpec+=mFontPath + "/";
				}else if(fDefaultFontPath!=null){
					mFontSpec+=fDefaultFontPath + "/";
				}else{
					throw new IllegalArgumentException("Font Path not set");
				}
				String mFontFile = elementFont.getAttribute("file");
				mFontSpec+=mFontFile;
				String mIndex = elementFont.getAttribute("index");
				if(!mIndex.equals("")){
					mFontSpec+=","+mIndex;
				}
				if(elementFont.getAttribute("embedded").equals("no")){
					mEmbedded=BaseFont.NOT_EMBEDDED;
					System.out.println("embedded:no");
				}
				String mLang = elementFont.getAttribute("lang");
				if(mLang.equals("jp")){
					BaseFont mBf = BaseFont.createFont(mFontSpec,BaseFont.IDENTITY_H, mEmbedded);
					fBaseFonts.put(mFontFamily,mBf);
					BaseFont mBfv = BaseFont.createFont(mFontSpec,BaseFont.IDENTITY_V, mEmbedded);
					fBaseFontsV.put(mFontFamily,mBfv);
				}else{
					BaseFont mBf = BaseFont.createFont(mFontSpec,BaseFont.WINANSI, mEmbedded);
					fBaseFonts.put(mFontFamily,mBf);
					BaseFont mBfv = BaseFont.createFont(mFontSpec,BaseFont.WINANSI, mEmbedded);
					fBaseFontsV.put(mFontFamily,mBfv);
				}
			}
		}catch(DocumentException e){
			e.printStackTrace();
		}catch(IOException e){
			e.printStackTrace();
		}
	}

	public static BaseFont getBaseFont(String aFamily){
		BaseFont bf = fBaseFonts.get(aFamily);
		if(bf==null){
			throw new IllegalArgumentException("font-family not found:" + aFamily);
		}
		return bf;
	}

	public static BaseFont getBaseFontV(String aFamily){
		BaseFont bf = fBaseFontsV.get(aFamily);
		if(bf==null){
			throw new IllegalArgumentException("font-family not found:" + aFamily);
		}
		return bf;
	}

	public static void setDefaultFontPath(String aDefaultFontPath){
		fDefaultFontPath = aDefaultFontPath;
	}

}

