package jp.veltec.pdf;
import com.itextpdf.text.pdf.PdfPCell;
import java.util.HashMap;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.Font;

import org.w3c.dom.Node;
import org.w3c.dom.NamedNodeMap;
import com.itextpdf.text.Element;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.Phrase;

/**
*表のセルを表すクラスです。
*/
public class Cell extends PdfPCell{
	HashMap<String,String> fAttributes = new HashMap<String,String>();
	BaseFont bf = FontManager.getBaseFont("明朝");
	Font fFont  = new Font(bf, 12);
	float fFontSize = 12f;
	float fLineHeight=1f;
	float fCharacterSpacing=0f;

	/**
	* テーブルにおける属性のデフォルトを設定します。
	* @param aTableDefault 属性のデフォルト値をセットしたHashMap
	*/
	public void setTableDefault(HashMap<String,String> aTableDefault){
		fAttributes.putAll(aTableDefault);
	}

	/**
	* 行における属性のデフォルトを設定します。
	* @param aRowDefault 属性のデフォルト値をセットしたHashMap
	*/
	public void setRowDefault(HashMap<String,String> aRowDefault){
		fAttributes.putAll(aRowDefault);
	}


	void setAttributes(org.w3c.dom.Element td){
		String attribute;
		NamedNodeMap map = td.getAttributes();
		for(int i=0;i<map.getLength();i++){
			Node node = map.item(i);
			fAttributes.put(node.getNodeName(),node.getNodeValue());
		}
		attribute = fAttributes.get("min-height");
		if(attribute!=null){
			setMinimumHeight(Util.getSize(attribute));
		}
		attribute = fAttributes.get("height");
		if(attribute!=null){
			setFixedHeight(Util.getSize(attribute));
		}
		attribute = fAttributes.get("align-h");
		if(attribute!=null){
			if(attribute.equals("center")){
				setHorizontalAlignment(Element.ALIGN_CENTER);
			}else if(attribute.equals("right")){
				setHorizontalAlignment(Element.ALIGN_RIGHT);
			}else if(attribute.equals("left")){
				setHorizontalAlignment(Element.ALIGN_LEFT);
			}
		}
		attribute = fAttributes.get("align-v");
		if(attribute!=null){
			if(attribute.equals("middle")){
				setVerticalAlignment(Element.ALIGN_MIDDLE);
			}else if(attribute.equals("bottom")){
				setVerticalAlignment(Element.ALIGN_BOTTOM);
			}else if(attribute.equals("top")){
				setVerticalAlignment(Element.ALIGN_TOP);
			}
		}
		attribute = fAttributes.get("font-family");
		if(attribute!=null){
			BaseFont bf = FontManager.getBaseFont(attribute);
			fFont = new Font(bf,fFontSize);
		}
		attribute = fAttributes.get("font-style");
		if(attribute!=null){
			fFont.setStyle(attribute);
		}
		attribute = fAttributes.get("font-size");
		if(attribute!=null){
			fFontSize=Util.getSize(attribute);
			fFont.setSize(fFontSize);
		}
		attribute=fAttributes.get("font-color");
		if(attribute!=null){
			fFont.setColor(Util.getColor(attribute));
		}
		attribute=fAttributes.get("background-color");
		if(attribute!=null){
			setBackgroundColor(Util.getColor(attribute));
		}
		attribute = fAttributes.get("border-width");
		if(attribute!=null){
			//setBorderWidth(Util.getSize(attribute));
			setBorderWidthTop(Util.getSize(attribute));
			setBorderWidthBottom(Util.getSize(attribute));
			setBorderWidthLeft(Util.getSize(attribute));
			setBorderWidthRight(Util.getSize(attribute));
		}
		attribute = fAttributes.get("border-width-top");
		if(attribute!=null){
			setBorderWidthTop(Util.getSize(attribute));
		}
		attribute = fAttributes.get("border-width-bottom");
		if(attribute!=null){
			setBorderWidthBottom(Util.getSize(attribute));
		}
		attribute = fAttributes.get("border-width-left");
		if(attribute!=null){
			setBorderWidthLeft(Util.getSize(attribute));
		}
		attribute = fAttributes.get("border-width-right");
		if(attribute!=null){
			setBorderWidthRight(Util.getSize(attribute));
		}
		attribute = fAttributes.get("border-color");
		if(attribute!=null){
			setBorderColor(Util.getColor(attribute));
		}
		attribute = fAttributes.get("border-color-left");
		if(attribute!=null){
			setBorderColorLeft(Util.getColor(attribute));
		}
		attribute = fAttributes.get("border-color-right");
		if(attribute!=null){
			setBorderColorRight(Util.getColor(attribute));
		}
		attribute = fAttributes.get("border-color-top");
		if(attribute!=null){
			setBorderColorTop(Util.getColor(attribute));
		}
		attribute = fAttributes.get("border-color-bottom");
		if(attribute!=null){
			setBorderColorBottom(Util.getColor(attribute));
		}
		attribute = fAttributes.get("padding");
		if(attribute!=null){
			setPadding(Util.getSize(attribute));
		}
		attribute = fAttributes.get("padding-left");
		if(attribute!=null){
			setPaddingLeft(Util.getSize(attribute));
		}
		attribute = fAttributes.get("padding-right");
		if(attribute!=null){
			setPaddingRight(Util.getSize(attribute));
		}
		attribute = fAttributes.get("padding-top");
		if(attribute!=null){
			setPaddingTop(Util.getSize(attribute));
		}
		attribute = fAttributes.get("padding-bottom");
		if(attribute!=null){
			setPaddingBottom(Util.getSize(attribute));
		}
		attribute = fAttributes.get("rotation");
		if(attribute!=null){
			if(attribute.equals("left")){
				setRotation(90);
			}else if(attribute.equals("right")){
				setRotation(270);
			}else if(attribute.equals("up")){
				setRotation(0);
			}else if(attribute.equals("down")){
				setRotation(180);
			}
		}
		attribute = fAttributes.get("line-height");
		if(attribute!=null){
			setLeading(0,Float.parseFloat(attribute));
		}
		attribute = fAttributes.get("character-spacing");
		if(attribute!=null){
			fCharacterSpacing=Util.getSize(attribute);
		}
	}

	void setContent(String aContent){
		aContent=aContent.replaceAll("\\\\n","\n");
		Chunk chunk = new Chunk(aContent,fFont);
		chunk.setCharacterSpacing(fCharacterSpacing);
		setPhrase(new Phrase(chunk));
	}
}

