/*
 * Decompiled with CFR 0.152.
 */
package jp.veltec.pdf;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Rectangle;

public class Util {
    public static float getSize(String string) throws IllegalArgumentException {
        if (string.endsWith("mm")) {
            string = string.substring(0, string.length() - 2);
            return 2.8346457f * Float.parseFloat(string);
        }
        if (string.endsWith("pt")) {
            string = string.substring(0, string.length() - 2);
            return Float.parseFloat(string);
        }
        throw new IllegalArgumentException("size format error:" + string);
    }

    public static Rectangle getStandardSize(String string) {
        Rectangle rectangle = null;
        if (string.equals("A3")) {
            float f = Util.getSize("297mm");
            float f2 = Util.getSize("420mm");
            rectangle = new Rectangle(f, f2);
        } else if (string.equals("A3L")) {
            float f = Util.getSize("420mm");
            float f3 = Util.getSize("297mm");
            rectangle = new Rectangle(f, f3);
        } else if (string.equals("A4")) {
            float f = Util.getSize("210mm");
            float f4 = Util.getSize("297mm");
            rectangle = new Rectangle(f, f4);
        } else if (string.equals("A4L")) {
            float f = Util.getSize("297mm");
            float f5 = Util.getSize("210mm");
            rectangle = new Rectangle(f, f5);
        } else if (string.equals("A5")) {
            float f = Util.getSize("148mm");
            float f6 = Util.getSize("210mm");
            rectangle = new Rectangle(f, f6);
        } else if (string.equals("A5L")) {
            float f = Util.getSize("210mm");
            float f7 = Util.getSize("148mm");
            rectangle = new Rectangle(f, f7);
        } else if (string.equals("A6")) {
            float f = Util.getSize("105mm");
            float f8 = Util.getSize("148mm");
            rectangle = new Rectangle(f, f8);
        } else if (string.equals("A6L")) {
            float f = Util.getSize("148mm");
            float f9 = Util.getSize("105mm");
            rectangle = new Rectangle(f, f9);
        } else if (string.equals("B4")) {
            float f = Util.getSize("257mm");
            float f10 = Util.getSize("364mm");
            rectangle = new Rectangle(f, f10);
        } else if (string.equals("B4L")) {
            float f = Util.getSize("364mm");
            float f11 = Util.getSize("257mm");
            rectangle = new Rectangle(f, f11);
        } else if (string.equals("B5")) {
            float f = Util.getSize("182mm");
            float f12 = Util.getSize("257mm");
            rectangle = new Rectangle(f, f12);
        } else if (string.equals("B5L")) {
            float f = Util.getSize("257mm");
            float f13 = Util.getSize("182mm");
            rectangle = new Rectangle(f, f13);
        } else if (string.equals("B6")) {
            float f = Util.getSize("128mm");
            float f14 = Util.getSize("182mm");
            rectangle = new Rectangle(f, f14);
        } else if (string.equals("B6L")) {
            float f = Util.getSize("182mm");
            float f15 = Util.getSize("128mm");
            rectangle = new Rectangle(f, f15);
        } else if (string.equals("PostCard")) {
            float f = Util.getSize("100mm");
            float f16 = Util.getSize("148mm");
            rectangle = new Rectangle(f, f16);
        } else if (string.equals("PostCardL")) {
            float f = Util.getSize("148mm");
            float f17 = Util.getSize("100mm");
            rectangle = new Rectangle(f, f17);
        } else {
            throw new IllegalArgumentException("not supported document size:" + string);
        }
        return rectangle;
    }

    public static BaseColor getColor(String string) {
        if (string.equals("white")) {
            string = "#FFFFFF";
        } else if (string.equals("black")) {
            string = "#000000";
        } else if (string.equals("gray")) {
            string = "#808080";
        } else if (string.equals("red")) {
            string = "#FF0000";
        } else if (string.equals("green")) {
            string = "#00FF00";
        } else if (string.equals("blue")) {
            string = "#0000FF";
        } else if (string.equals("yellow")) {
            string = "#FFFF00";
        }
        try {
            int n = Integer.valueOf(string.substring(1, 3), 16);
            int n2 = Integer.valueOf(string.substring(3, 5), 16);
            int n3 = Integer.valueOf(string.substring(5, 7), 16);
            return new BaseColor(n, n2, n3);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("not supported color:" + string);
        }
    }
}

