/*
 * Decompiled with CFR 0.152.
 */
package jp.veltec.pdf;

import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfPTableEvent;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import jp.veltec.pdf.Cell;
import jp.veltec.pdf.DrawOuterBorder;
import jp.veltec.pdf.PdfLayout;
import jp.veltec.pdf.Util;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TableLayout
extends PdfLayout {
    HashMap<String, String> fTableDefault;
    HashMap<String, String> fRowDefault;

    public TableLayout(OutputStream outputStream) {
        super(outputStream);
    }

    @Override
    void process(HashMap<String, String> hashMap) throws DocumentException {
        NodeList nodeList = this.fTemplate.getElementsByTagName("table");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            int n;
            Object object;
            Object object2;
            org.w3c.dom.Element object3 = (org.w3c.dom.Element)nodeList.item(i);
            String string = object3.getAttribute("cols");
            if (string.equals("")) {
                throw new IllegalStateException("cols not specified");
            }
            int n2 = Integer.parseInt(string);
            PdfPTable pdfPTable = new PdfPTable(n2);
            float f = Util.getSize("0.2mm");
            float f2 = Util.getSize("0.2mm");
            String string2 = object3.getAttribute("outer-border-width");
            if (!string2.equals("")) {
                DrawOuterBorder drawOuterBorder = new DrawOuterBorder();
                drawOuterBorder.setBorderWidth(Util.getSize(string2));
                pdfPTable.setTableEvent((PdfPTableEvent)drawOuterBorder);
            }
            if (!(string2 = object3.getAttribute("margin-top")).equals("")) {
                pdfPTable.setSpacingBefore(Util.getSize(string2));
            }
            if (!(string2 = object3.getAttribute("margin-bottom")).equals("")) {
                pdfPTable.setSpacingAfter(Util.getSize(string2));
            } else {
                pdfPTable.setSpacingAfter(Util.getSize("5mm"));
            }
            string2 = object3.getAttribute("table-align");
            if (!string2.equals("")) {
                if (string2.equals("left")) {
                    pdfPTable.setHorizontalAlignment(0);
                } else if (string2.equals("center")) {
                    pdfPTable.setHorizontalAlignment(1);
                } else if (string2.equals("right")) {
                    pdfPTable.setHorizontalAlignment(2);
                } else {
                    throw new IllegalArgumentException("bad table-align:" + string2);
                }
            }
            pdfPTable.setLockedWidth(true);
            float f3 = 0.0f;
            string2 = object3.getAttribute("widths");
            if (!string2.equals("")) {
                object2 = string2.split(" ");
                object = new float[((String[])object2).length];
                for (n = 0; n < ((String[])object2).length; ++n) {
                    object[n] = Util.getSize(object2[n]);
                    f3 += object[n];
                }
                pdfPTable.setWidths((float[])object);
            }
            if (f3 == 0.0f) {
                pdfPTable.setTotalWidth(this.fDocument.getPageSize().getWidth() - this.fDocument.leftMargin() - this.fDocument.rightMargin());
            } else {
                pdfPTable.setTotalWidth(f3);
            }
            this.fTableDefault = new HashMap();
            object2 = object3.getAttributes();
            for (int j = 0; j < object2.getLength(); ++j) {
                Node node = object2.item(j);
                this.fTableDefault.put(node.getNodeName(), node.getNodeValue());
            }
            object = object3.getElementsByTagName("tr");
            n = object.getLength();
            for (int j = 0; j < n; ++j) {
                org.w3c.dom.Element element = (org.w3c.dom.Element)object.item(j);
                this.fRowDefault = new HashMap();
                NamedNodeMap namedNodeMap = element.getAttributes();
                for (int k = 0; k < namedNodeMap.getLength(); ++k) {
                    Node node = namedNodeMap.item(k);
                    this.fRowDefault.put(node.getNodeName(), node.getNodeValue());
                }
                NodeList nodeList2 = element.getElementsByTagName("td");
                for (int k = 0; k < nodeList2.getLength(); ++k) {
                    Object object4;
                    Object object5;
                    org.w3c.dom.Element element2 = (org.w3c.dom.Element)nodeList2.item(k);
                    Object object6 = element2.getTextContent();
                    String string3 = element2.getAttribute("id");
                    if (!string3.equals("")) {
                        arrayList.add(string3);
                        object5 = hashMap.get(string3);
                        if (object5 != null) {
                            object6 = object5;
                        }
                        if ((object4 = (HashMap)this.fExtraAttributes.get(string3)) != null) {
                            for (Map.Entry entry : ((HashMap)object4).entrySet()) {
                                element2.setAttribute((String)entry.getKey(), (String)entry.getValue());
                            }
                        }
                    }
                    object5 = new Cell();
                    ((Cell)((Object)object5)).setTableDefault(this.fTableDefault);
                    ((Cell)((Object)object5)).setRowDefault(this.fRowDefault);
                    object4 = element2.getAttribute("colspan");
                    int n3 = 1;
                    if (!((String)object4).equals("")) {
                        n3 = Integer.parseInt((String)object4);
                        object5.setColspan(n3);
                    }
                    int n4 = 1;
                    String string4 = element2.getAttribute("rowspan");
                    if (!string4.equals("")) {
                        n4 = Integer.parseInt(string4);
                        object5.setRowspan(n4);
                    }
                    ((Cell)((Object)object5)).setAttributes(element2);
                    ((Cell)((Object)object5)).setContent((String)object6);
                    pdfPTable.addCell((PdfPCell)object5);
                }
            }
            string2 = object3.getAttribute("position");
            if (string2.equals("absolute")) {
                if (object3.getAttribute("left").equals("") || object3.getAttribute("top").equals("")) {
                    throw new IllegalArgumentException("left and top must be set for absolute position table");
                }
                float f4 = Util.getSize(object3.getAttribute("left"));
                float f5 = this.fDocument.getPageSize().getHeight() - Util.getSize(object3.getAttribute("top"));
                pdfPTable.writeSelectedRows(0, -1, f4, f5, this.fDirectContent);
                continue;
            }
            this.fDocument.add((Element)pdfPTable);
        }
        for (String string : hashMap.keySet()) {
            if (arrayList.contains(string)) continue;
            throw new IllegalArgumentException("id not found:" + string);
        }
    }
}

