/*
 * Decompiled with CFR 0.152.
 */
package jp.veltec.pdf;

import com.itextpdf.text.BadElementException;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.ExceptionConverter;
import com.itextpdf.text.Image;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfImportedPage;
import com.itextpdf.text.pdf.PdfPageEvent;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jp.veltec.pdf.FontManager;
import jp.veltec.pdf.PageHeaderWriter;
import jp.veltec.pdf.PageNumberWriter;
import jp.veltec.pdf.PdfException;
import jp.veltec.pdf.Util;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class PdfLayout {
    OutputStream fOutputStream;
    Element fTemplate;
    Document fDocument;
    PdfWriter fWriter;
    PageNumberWriter fPageNumberWriter;
    PageHeaderWriter fPageHeaderWriter;
    PdfContentByte fDirectContent;
    PdfContentByte fDirectContentUnder;
    String fImagePath = ".";
    HashMap<String, HashMap<String, String>> fExtraAttributes = new HashMap();
    HashMap<String, String> fData = new HashMap();

    public PdfLayout(OutputStream outputStream) {
        try {
            this.fOutputStream = outputStream;
            this.fDocument = new Document();
            this.fWriter = PdfWriter.getInstance((Document)this.fDocument, (OutputStream)this.fOutputStream);
        }
        catch (DocumentException documentException) {
            documentException.printStackTrace();
        }
    }

    public void setData(String string, String string2) {
        this.fData.put(string, string2);
    }

    public void clearData() {
        this.fData.clear();
    }

    public void setAttributes(HashMap<String, HashMap<String, String>> hashMap) {
        this.fExtraAttributes = hashMap;
    }

    public void clearAttributes() {
        this.fExtraAttributes.clear();
    }

    public void setAttribute(String string, String string2, String string3) {
        HashMap<String, String> hashMap = this.fExtraAttributes.get(string);
        if (hashMap == null) {
            hashMap = new HashMap();
            this.fExtraAttributes.put(string, hashMap);
        }
        hashMap.put(string2, string3);
    }

    public void removeAttribute(String string, String string2) {
        HashMap<String, String> hashMap = this.fExtraAttributes.get(string);
        if (hashMap == null) {
            throw new IllegalArgumentException(string + " not exists.");
        }
        hashMap.remove(string2);
    }

    public void setImagePath(String string) {
        this.fImagePath = string;
    }

    public void setFontPath(String string) {
        FontManager.setDefaultFontPath(string);
    }

    public void setPageNumber(int n) {
        this.fPageNumberWriter.setPageNumber(n);
    }

    public void setPageHeaderText(String string) {
        this.fPageHeaderWriter.setHeaderText(string);
    }

    public void setTemplateFile(File file) throws IOException {
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            org.w3c.dom.Document document = documentBuilder.parse(file);
            Element element = document.getDocumentElement();
            this.setTemplate(element);
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
            throw new IllegalStateException(sAXException.getMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
            throw new IllegalStateException(parserConfigurationException.getMessage());
        }
    }

    public void setTemplate(Element element) {
        NodeList nodeList;
        NodeList nodeList2;
        float f;
        float f2;
        this.fTemplate = element;
        Rectangle rectangle = PageSize.A4;
        String string = this.fTemplate.getAttribute("size");
        if (!string.equals("")) {
            String[] stringArray = string.split(" ");
            if (stringArray.length == 1) {
                rectangle = Util.getStandardSize(string);
            } else if (stringArray.length == 2) {
                f2 = Util.getSize(stringArray[0]);
                f = Util.getSize(stringArray[1]);
                rectangle = new Rectangle(f2, f);
            } else {
                throw new IllegalArgumentException("not supported document size:" + string);
            }
        }
        this.fDocument.setPageSize(rectangle);
        float f3 = Util.getSize("15mm");
        string = this.fTemplate.getAttribute("margin-left");
        if (!string.equals("")) {
            f3 = Util.getSize(string);
        }
        f2 = Util.getSize("15mm");
        string = this.fTemplate.getAttribute("margin-right");
        if (!string.equals("")) {
            f2 = Util.getSize(string);
        }
        f = Util.getSize("15mm");
        string = this.fTemplate.getAttribute("margin-top");
        if (!string.equals("")) {
            f = Util.getSize(string);
        }
        float f4 = Util.getSize("15mm");
        string = this.fTemplate.getAttribute("margin-bottom");
        if (!string.equals("")) {
            f4 = Util.getSize(string);
        }
        this.fDocument.setMargins(f3, f2, f, f4);
        NodeList nodeList3 = this.fTemplate.getElementsByTagName("font");
        if (nodeList3.getLength() != 0) {
            FontManager.clearFonts();
            FontManager.register(nodeList3);
        }
        if ((nodeList2 = this.fTemplate.getElementsByTagName("page")).getLength() != 0) {
            if (nodeList2.getLength() != 1) {
                throw new IllegalArgumentException("more than one page elements found");
            }
            this.fPageNumberWriter = new PageNumberWriter(this);
            this.fPageNumberWriter.setDocument(this.fDocument);
            this.fPageNumberWriter.setPageLabel((Element)nodeList2.item(0));
            this.fWriter.setPageEvent((PdfPageEvent)this.fPageNumberWriter);
        }
        if ((nodeList = this.fTemplate.getElementsByTagName("page-header")).getLength() != 0) {
            if (nodeList.getLength() != 1) {
                throw new IllegalArgumentException("more than one page-header elements found");
            }
            this.fPageHeaderWriter = new PageHeaderWriter(this);
            this.fPageHeaderWriter.setDocument(this.fDocument);
            this.fPageHeaderWriter.setPageLabel((Element)nodeList.item(0));
            this.fWriter.setPageEvent((PdfPageEvent)this.fPageHeaderWriter);
        }
        this.fDocument.open();
        this.fDirectContent = this.fWriter.getDirectContent();
        this.fDirectContentUnder = this.fWriter.getDirectContentUnder();
    }

    public void addPage() throws IllegalStateException {
        this.addPage(this.fData);
    }

    public void addPage(HashMap<String, String> hashMap) throws IllegalStateException {
        try {
            this.process(hashMap);
            this.processPDF();
            this.processImage();
            this.processRectangle();
            this.processLine();
            this.fDocument.newPage();
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalStateException(malformedURLException.getMessage());
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.getMessage());
        }
        catch (DocumentException documentException) {
            throw new IllegalStateException(documentException.getMessage());
        }
    }

    abstract void process(HashMap<String, String> var1) throws DocumentException;

    public void close() throws PdfException {
        try {
            this.fDocument.close();
        }
        catch (ExceptionConverter exceptionConverter) {
            throw new PdfException(exceptionConverter.getMessage());
        }
    }

    void processImage() throws BadElementException, DocumentException, MalformedURLException, IOException {
        NodeList nodeList = this.fTemplate.getElementsByTagName("img");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Object object;
            Element element = (Element)nodeList.item(i);
            String string = element.getAttribute("id");
            if (!string.equals("") && (object = this.fExtraAttributes.get(string)) != null) {
                for (Map.Entry entry : ((HashMap)object).entrySet()) {
                    element.setAttribute((String)entry.getKey(), (String)entry.getValue());
                }
            }
            object = element.getAttribute("src");
            String string2 = element.getAttribute("path");
            object = !string2.equals("") ? (String)string2 + "/" + (String)object : this.fImagePath + "/" + (String)object;
            Image entry2 = Image.getInstance((String)object);
            Object var8_10 = null;
            String string3 = element.getAttribute("width");
            String string4 = element.getAttribute("height");
            float f = entry2.getWidth();
            float f2 = entry2.getHeight();
            if (!string3.equals("")) {
                f = Util.getSize(string3);
                if (string4.equals("")) {
                    f2 = entry2.getHeight() * f / entry2.getWidth();
                }
            }
            if (!string4.equals("")) {
                f2 = Util.getSize(string4);
                if (string3.equals("")) {
                    f = entry2.getWidth() * f2 / entry2.getHeight();
                }
            }
            entry2.scaleAbsolute(f, f2);
            float f3 = Util.getSize(element.getAttribute("top"));
            float f4 = Util.getSize(element.getAttribute("left"));
            entry2.setAbsolutePosition(f4, this.fDocument.getPageSize().getHeight() - f3 - f2);
            String string5 = element.getAttribute("background");
            boolean bl = string5.equals("true");
            if (bl) {
                this.fDirectContentUnder.addImage(entry2);
                continue;
            }
            this.fDirectContent.addImage(entry2);
        }
    }

    void processPDF() throws BadElementException, DocumentException, MalformedURLException, IOException {
        try {
            Object object2;
            NodeList nodeList = this.fTemplate.getElementsByTagName("pdf");
            if (nodeList.getLength() > 1) {
                throw new IllegalArgumentException("only one pdf can be included.");
            }
            Element element = (Element)nodeList.item(0);
            if (element == null) {
                return;
            }
            String string = element.getAttribute("id");
            if (!string.equals("") && (object2 = this.fExtraAttributes.get(string)) != null) {
                for (Map.Entry object3 : ((HashMap)object2).entrySet()) {
                    element.setAttribute((String)object3.getKey(), (String)object3.getValue());
                }
            }
            object2 = element.getAttribute("src");
            String string2 = element.getAttribute("path");
            object2 = !string2.equals("") ? (String)string2 + "/" + (String)object2 : this.fImagePath + "/" + (String)object2;
            String string3 = element.getAttribute("page");
            int n = 1;
            if (!string3.equals("")) {
                n = Integer.parseInt(string3);
            }
            String string4 = element.getAttribute("left");
            float f = 0.0f;
            if (!string4.equals("")) {
                f = Util.getSize(string4);
            }
            String string5 = element.getAttribute("top");
            float f2 = 0.0f;
            if (!string5.equals("")) {
                f2 = Util.getSize(string5);
            }
            PdfReader pdfReader = new PdfReader((String)object2);
            PdfImportedPage pdfImportedPage = this.fWriter.getImportedPage(pdfReader, n);
            Image image = Image.getInstance((PdfTemplate)pdfImportedPage);
            image.setAbsolutePosition(f, this.fDocument.getPageSize().getHeight() - image.getHeight() - f2);
            String string6 = element.getAttribute("background");
            boolean bl = string6.equals("true");
            if (bl) {
                this.fDirectContentUnder.addImage(image);
            } else {
                this.fDirectContent.addImage(image);
            }
        }
        catch (Exception exception) {
            if (exception.getMessage().indexOf("password") != -1) {
                throw new IllegalArgumentException("PDF requires password, not supported.");
            }
            throw new IllegalArgumentException(exception.getMessage());
        }
    }

    void processRectangle() throws BadElementException, DocumentException, MalformedURLException, IOException {
        NodeList nodeList = this.fTemplate.getElementsByTagName("rect");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            PdfContentByte pdfContentByte;
            Element element = (Element)nodeList.item(i);
            String string = element.getAttribute("id");
            if (!string.equals("") && (pdfContentByte = this.fExtraAttributes.get(string)) != null) {
                for (Map.Entry<String, String> entry : pdfContentByte.entrySet()) {
                    element.setAttribute(entry.getKey(), entry.getValue());
                }
            }
            pdfContentByte = null;
            pdfContentByte = element.getAttribute("background").equals("true") ? this.fDirectContentUnder : this.fDirectContent;
            pdfContentByte.saveState();
            float f = Util.getSize(element.getAttribute("left"));
            float f2 = Util.getSize(element.getAttribute("width"));
            float f3 = Util.getSize(element.getAttribute("height"));
            float f4 = this.fDocument.getPageSize().getHeight() - Util.getSize(element.getAttribute("top")) - f3;
            String string2 = element.getAttribute("border-width");
            if (!string2.equals("")) {
                pdfContentByte.setLineWidth(Util.getSize(string2));
            }
            if (!(string2 = element.getAttribute("border-color")).equals("")) {
                pdfContentByte.setColorStroke(Util.getColor(string2));
            }
            pdfContentByte.setColorFill(BaseColor.WHITE);
            string2 = element.getAttribute("color");
            if (!string2.equals("")) {
                pdfContentByte.setColorFill(Util.getColor(string2));
            }
            if (!(string2 = element.getAttribute("round")).equals("")) {
                float f5 = Util.getSize(string2);
                pdfContentByte.roundRectangle(f, f4, f2, f3, f5);
            } else {
                pdfContentByte.rectangle(f, f4, f2, f3);
            }
            pdfContentByte.fillStroke();
            pdfContentByte.restoreState();
        }
    }

    void processLine() throws BadElementException, DocumentException, MalformedURLException, IOException {
        NodeList nodeList = this.fTemplate.getElementsByTagName("line");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            PdfContentByte pdfContentByte;
            Element element = (Element)nodeList.item(i);
            String string = element.getAttribute("id");
            if (!string.equals("") && (pdfContentByte = this.fExtraAttributes.get(string)) != null) {
                for (Map.Entry<String, String> entry : pdfContentByte.entrySet()) {
                    element.setAttribute(entry.getKey(), entry.getValue());
                }
            }
            pdfContentByte = null;
            pdfContentByte = element.getAttribute("background").equals("true") ? this.fDirectContentUnder : this.fDirectContent;
            pdfContentByte.saveState();
            float f = Util.getSize(element.getAttribute("from").split(" ")[0]);
            float f2 = this.fDocument.getPageSize().getHeight() - Util.getSize(element.getAttribute("from").split(" ")[1]);
            float f3 = Util.getSize(element.getAttribute("to").split(" ")[0]);
            float f4 = this.fDocument.getPageSize().getHeight() - Util.getSize(element.getAttribute("to").split(" ")[1]);
            String string2 = element.getAttribute("width");
            if (!string2.equals("")) {
                pdfContentByte.setLineWidth(Util.getSize(string2));
            }
            if (!(string2 = element.getAttribute("color")).equals("")) {
                pdfContentByte.setColorStroke(Util.getColor(string2));
            }
            pdfContentByte.moveTo(f, f2);
            pdfContentByte.lineTo(f3, f4);
            pdfContentByte.stroke();
            pdfContentByte.restoreState();
        }
    }
}

