/*
 * Decompiled with CFR 0.152.
 */
package jp.veltec.pdf;

import com.itextpdf.text.Document;
import com.itextpdf.text.Font;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.ColumnText;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfPageEventHelper;
import com.itextpdf.text.pdf.PdfWriter;
import jp.veltec.pdf.FontManager;
import jp.veltec.pdf.ListTableLayout;
import jp.veltec.pdf.PdfLayout;
import jp.veltec.pdf.Util;
import org.w3c.dom.Element;

class PageNumberWriter
extends PdfPageEventHelper {
    Document fDocument = null;
    int fPageNumber = 1;
    float fPositionX = 0.0f;
    float fPositionY = 0.0f;
    int fAlign = 0;
    String fTextBefore = "";
    String fTextAfter = "";
    Rectangle rect = PageSize.A4;
    BaseFont fBaseFont = FontManager.getBaseFont("default");
    Font fFont = new Font(this.fBaseFont, this.fFontSize);
    float fFontSize = 12.0f;
    int fFontStyle;

    public PageNumberWriter(PdfLayout pdfLayout) {
    }

    public PageNumberWriter(ListTableLayout listTableLayout) {
    }

    public void setDocument(Document document) {
        this.fDocument = document;
    }

    public void setPageNumber(int n) {
        this.fPageNumber = n;
    }

    public void setFontFamily(String string) {
        this.fBaseFont = FontManager.getBaseFont(string);
        this.fFont = new Font(this.fBaseFont, this.fFontSize);
        this.fFont.setStyle(this.fFontStyle);
    }

    public void setFontSize(float f) {
        this.fFontSize = f;
        this.fFont.setSize(f);
    }

    public void setFontStyle(int n) {
        this.fFontStyle = n;
        this.fFont.setStyle(this.fFontStyle);
    }

    public void setPosition(float f, float f2) {
        this.fPositionX = f;
        this.fPositionY = f2;
    }

    public void setAlign(int n) {
        this.fAlign = n;
    }

    public void setTextBefore(String string) {
        this.fTextBefore = string;
    }

    public void setTextAfter(String string) {
        this.fTextAfter = string;
    }

    public void onStartPage(PdfWriter pdfWriter, Document document) {
    }

    public void onEndPage(PdfWriter pdfWriter, Document document) {
        String string = this.fTextBefore + Integer.toString(this.fPageNumber) + this.fTextAfter;
        ColumnText.showTextAligned((PdfContentByte)pdfWriter.getDirectContent(), (int)this.fAlign, (Phrase)new Phrase(string, this.fFont), (float)this.fPositionX, (float)this.fPositionY, (float)0.0f);
        ++this.fPageNumber;
    }

    public void setPageLabel(Element element) {
        float f = Util.getSize("5mm");
        String string = element.getAttribute("margin");
        if (!string.equals("")) {
            f = Util.getSize(string);
        }
        float f2 = 0.0f;
        float f3 = 0.0f;
        int n = 0;
        string = element.getAttribute("position");
        if (string.equals("top-left")) {
            f2 = f;
            f3 = this.fDocument.getPageSize().getHeight() - f;
        } else if (string.equals("top-center")) {
            f2 = this.fDocument.getPageSize().getWidth() / 2.0f;
            f3 = this.fDocument.getPageSize().getHeight() - f;
            n = 1;
        } else if (string.equals("top-right")) {
            f2 = this.fDocument.getPageSize().getWidth() - f;
            f3 = this.fDocument.getPageSize().getHeight() - f;
            n = 1;
        } else if (string.equals("bottom-left")) {
            f2 = f;
            f3 = f;
        } else if (string.equals("bottom-center") || string.equals("")) {
            f2 = this.fDocument.getPageSize().getWidth() / 2.0f;
            f3 = f;
            n = 1;
        } else if (string.equals("bottom-right")) {
            f2 = this.fDocument.getPageSize().getWidth() - f;
            f3 = f;
            n = 1;
        } else {
            f2 = Util.getSize(string.split(" ")[0]);
            f3 = this.fDocument.getPageSize().getHeight() - Util.getSize(string.split(" ")[1]);
        }
        this.setPosition(f2, f3);
        this.setAlign(n);
        string = element.getAttribute("text-before");
        if (!string.equals("")) {
            this.setTextBefore(string);
        }
        if (!(string = element.getAttribute("text-after")).equals("")) {
            this.setTextAfter(string);
        }
        if (!(string = element.getAttribute("font-size")).equals("")) {
            this.setFontSize(Util.getSize(string));
        }
        if (!(string = element.getAttribute("font-family")).equals("")) {
            this.setFontFamily(string);
        }
        if (!(string = element.getAttribute("font-style")).equals("")) {
            if (string.equals("bold")) {
                this.setFontStyle(1);
            } else if (string.equals("italic")) {
                this.setFontStyle(2);
            } else if (string.equals("bold-italic")) {
                this.setFontStyle(3);
            } else {
                throw new IllegalArgumentException("not supported font-style:" + string);
            }
        }
    }
}

