/*
 * Decompiled with CFR 0.152.
 */
package jp.veltec.pdf;

import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.ExceptionConverter;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfPTableEvent;
import com.itextpdf.text.pdf.PdfPageEvent;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jp.veltec.pdf.Cell;
import jp.veltec.pdf.DrawOuterBorder;
import jp.veltec.pdf.FontManager;
import jp.veltec.pdf.PageHeaderWriter;
import jp.veltec.pdf.PageNumberWriter;
import jp.veltec.pdf.PdfException;
import jp.veltec.pdf.Util;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ListTableLayout {
    OutputStream fOutputStream;
    org.w3c.dom.Element fTemplate;
    Document fDocument;
    float fDocumentHeight;
    PdfWriter fWriter;
    HashMap<String, String> fTableDefault;
    HashMap<String, String> fRowDefault;
    HashMap<String, String> fHeaderData = new HashMap();
    HashMap<String, String> fRecordData = new HashMap();
    HashMap<String, String> fFooterData = new HashMap();
    HashMap<String, HashMap<String, String>> fExtraAttributes = new HashMap();
    NodeList fHeaderTrs;
    NodeList fRecordTrs;
    NodeList fFooterTrs;
    PdfPTable fPdfTable;
    int fRows;
    int fRowCounter;
    int fCols;
    int fHeaderRows;
    boolean[][] fMatrix;
    boolean fRepeat;
    String fName;
    PageHeaderWriter fPageHeaderWriter;

    public ListTableLayout(OutputStream outputStream) {
        this.fOutputStream = outputStream;
        try {
            this.fDocument = new Document();
            this.fWriter = PdfWriter.getInstance((Document)this.fDocument, (OutputStream)this.fOutputStream);
        }
        catch (DocumentException documentException) {
            documentException.printStackTrace();
            throw new IllegalStateException(documentException.getMessage());
        }
    }

    public void setPageHeaderText(String string) {
        this.fPageHeaderWriter.setHeaderText(string);
    }

    public void setHeaderData(String string, String string2) {
        this.fHeaderData.put(string, string2);
    }

    public void setRecordData(String string, String string2) {
        this.fRecordData.put(string, string2);
    }

    public void setFooterData(String string, String string2) {
        this.fFooterData.put(string, string2);
    }

    public void clearHeaderData() {
        this.fHeaderData.clear();
    }

    public void clearRecordData() {
        this.fRecordData.clear();
    }

    public void clearFooterData() {
        this.fFooterData.clear();
    }

    public void setAttributes(HashMap<String, HashMap<String, String>> hashMap) {
        this.fExtraAttributes = hashMap;
    }

    public void clearAttributes() {
        this.fExtraAttributes.clear();
    }

    public void setAttribute(String string, String string2, String string3) {
        HashMap<String, String> hashMap = this.fExtraAttributes.get(string);
        if (hashMap == null) {
            hashMap = new HashMap();
            this.fExtraAttributes.put(string, hashMap);
        }
        hashMap.put(string2, string3);
    }

    public void removeAttribute(String string, String string2) {
        HashMap<String, String> hashMap = this.fExtraAttributes.get(string);
        if (hashMap == null) {
            throw new IllegalArgumentException(string + " not exists.");
        }
        hashMap.remove(string2);
    }

    public void setFontPath(String string) {
        FontManager.setDefaultFontPath(string);
    }

    public void setTemplateFile(File file) {
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            org.w3c.dom.Document document = documentBuilder.parse(file);
            org.w3c.dom.Element element = document.getDocumentElement();
            this.setTemplate(element);
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
            throw new IllegalStateException(sAXException.getMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
            throw new IllegalStateException(parserConfigurationException.getMessage());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new IllegalStateException(iOException.getMessage());
        }
    }

    public void setTemplate(org.w3c.dom.Element element) {
        Object object;
        NodeList nodeList;
        NodeList nodeList2;
        float f;
        float f2;
        this.fTemplate = element;
        Rectangle rectangle = PageSize.A4;
        String string = this.fTemplate.getAttribute("size");
        if (!string.equals("")) {
            String[] stringArray = string.split(" ");
            if (stringArray.length == 1) {
                rectangle = Util.getStandardSize(string);
            } else if (stringArray.length == 2) {
                f2 = Util.getSize(stringArray[0]);
                f = Util.getSize(stringArray[1]);
                rectangle = new Rectangle(f2, f);
            } else {
                throw new IllegalArgumentException("not supported document size:" + string);
            }
        }
        this.fDocument.setPageSize(rectangle);
        float f3 = Util.getSize("15mm");
        string = this.fTemplate.getAttribute("margin-left");
        if (!string.equals("")) {
            f3 = Util.getSize(string);
        }
        f2 = Util.getSize("15mm");
        string = this.fTemplate.getAttribute("margin-right");
        if (!string.equals("")) {
            f2 = Util.getSize(string);
        }
        f = Util.getSize("15mm");
        string = this.fTemplate.getAttribute("margin-top");
        if (!string.equals("")) {
            f = Util.getSize(string);
        }
        float f4 = Util.getSize("15mm");
        string = this.fTemplate.getAttribute("margin-bottom");
        if (!string.equals("")) {
            f4 = Util.getSize(string);
        }
        if ((nodeList2 = this.fTemplate.getElementsByTagName("font")).getLength() != 0) {
            FontManager.clearFonts();
            FontManager.register(nodeList2);
        }
        if ((nodeList = this.fTemplate.getElementsByTagName("page")).getLength() != 0) {
            if (nodeList.getLength() != 1) {
                throw new IllegalArgumentException("more than one page elements found");
            }
            object = new PageNumberWriter(this);
            ((PageNumberWriter)((Object)object)).setDocument(this.fDocument);
            ((PageNumberWriter)((Object)object)).setPageLabel((org.w3c.dom.Element)nodeList.item(0));
            this.fWriter.setPageEvent((PdfPageEvent)object);
        }
        if ((object = this.fTemplate.getElementsByTagName("page-header")).getLength() != 0) {
            if (object.getLength() != 1) {
                throw new IllegalArgumentException("more than one page-header elements found");
            }
            this.fPageHeaderWriter = new PageHeaderWriter(this);
            this.fPageHeaderWriter.setDocument(this.fDocument);
            this.fPageHeaderWriter.setPageLabel((org.w3c.dom.Element)object.item(0));
            this.fWriter.setPageEvent((PdfPageEvent)this.fPageHeaderWriter);
        }
        this.fDocument.setMargins(f3, f2, f, f4);
        this.fDocument.open();
        this.beginTable();
    }

    private void beginTable() throws IllegalStateException {
        try {
            org.w3c.dom.Element element;
            org.w3c.dom.Element element2;
            NodeList nodeList = this.fTemplate.getElementsByTagName("listtable");
            org.w3c.dom.Element element3 = (org.w3c.dom.Element)nodeList.item(0);
            String string = element3.getAttribute("cols");
            org.w3c.dom.Element element4 = (org.w3c.dom.Element)element3.getElementsByTagName("header").item(0);
            if (element4 != null) {
                this.fHeaderTrs = element4.getElementsByTagName("tr");
                this.fHeaderRows = this.fHeaderTrs.getLength();
            }
            if ((element2 = (org.w3c.dom.Element)element3.getElementsByTagName("record").item(0)) != null) {
                this.fRecordTrs = element2.getElementsByTagName("tr");
            }
            if ((element = (org.w3c.dom.Element)element3.getElementsByTagName("footer").item(0)) != null) {
                this.fFooterTrs = element.getElementsByTagName("tr");
            }
            if (string.equals("")) {
                throw new IllegalStateException("cols not specified");
            }
            this.fCols = Integer.parseInt(string);
            this.fPdfTable = new PdfPTable(this.fCols);
            this.fPdfTable.setLockedWidth(true);
            this.fPdfTable.setTotalWidth(this.fDocument.getPageSize().getWidth() - this.fDocument.leftMargin() - this.fDocument.rightMargin());
            this.fTableDefault = new HashMap();
            NamedNodeMap namedNodeMap = element3.getAttributes();
            this.fRepeat = false;
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Object object;
                Node node = namedNodeMap.item(i);
                if (node.getNodeName().equals("widths")) {
                    object = node.getNodeValue().split(" ");
                    float[] fArray = new float[((String[])object).length];
                    float f = 0.0f;
                    for (int j = 0; j < fArray.length; ++j) {
                        fArray[j] = Util.getSize((String)object[j]);
                        f += fArray[j];
                    }
                    this.fPdfTable.setWidths(fArray);
                    this.fPdfTable.setTotalWidth(f);
                    continue;
                }
                if (node.getNodeName().equals("name")) {
                    this.fName = node.getNodeValue();
                    continue;
                }
                if (node.getNodeName().equals("outer-border-width")) {
                    object = new DrawOuterBorder();
                    ((DrawOuterBorder)object).setBorderWidth(Util.getSize(node.getNodeValue()));
                    this.fPdfTable.setTableEvent((PdfPTableEvent)object);
                    continue;
                }
                if (node.getNodeName().equals("table-align")) {
                    object = node.getNodeValue();
                    if (((String)object).equals("left")) {
                        this.fPdfTable.setHorizontalAlignment(0);
                        continue;
                    }
                    if (((String)object).equals("center")) {
                        this.fPdfTable.setHorizontalAlignment(1);
                        continue;
                    }
                    if (((String)object).equals("right")) {
                        this.fPdfTable.setHorizontalAlignment(2);
                        continue;
                    }
                    throw new IllegalArgumentException("bad table-align:" + (String)object);
                }
                this.fTableDefault.put(node.getNodeName(), node.getNodeValue());
            }
        }
        catch (DocumentException documentException) {
            throw new IllegalStateException(documentException.getMessage());
        }
    }

    public void addHeader() throws IllegalStateException {
        this.addHeader(this.fHeaderData);
    }

    public void addHeader(HashMap<String, String> hashMap) throws IllegalStateException {
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            this.fPdfTable.setHeaderRows(this.fHeaderRows);
            if (this.fHeaderTrs == null) {
                throw new IllegalStateException("header is not found in the template");
            }
            for (int i = 0; i < this.fHeaderTrs.getLength(); ++i) {
                org.w3c.dom.Element object = (org.w3c.dom.Element)this.fHeaderTrs.item(i);
                this.fRowDefault = new HashMap();
                NamedNodeMap namedNodeMap = object.getAttributes();
                for (int j = 0; j < namedNodeMap.getLength(); ++j) {
                    Node node = namedNodeMap.item(j);
                    this.fRowDefault.put(node.getNodeName(), node.getNodeValue());
                }
                this.processRow(object, hashMap, arrayList);
            }
            for (String string : hashMap.keySet()) {
                if (arrayList.contains(string)) continue;
                throw new IllegalArgumentException("id not found:" + string);
            }
        }
        catch (DocumentException documentException) {
            throw new IllegalStateException(documentException.getMessage());
        }
    }

    public void addRecord() throws IllegalStateException {
        this.addRecord(this.fRecordData);
    }

    public void addRecord(HashMap<String, String> hashMap) throws IllegalStateException {
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (this.fRecordTrs == null) {
                throw new IllegalStateException("record is not found in the template");
            }
            for (int i = 0; i < this.fRecordTrs.getLength(); ++i) {
                org.w3c.dom.Element object = (org.w3c.dom.Element)this.fRecordTrs.item(i);
                this.fRowDefault = new HashMap();
                NamedNodeMap namedNodeMap = object.getAttributes();
                for (int j = 0; j < namedNodeMap.getLength(); ++j) {
                    Node node = namedNodeMap.item(j);
                    this.fRowDefault.put(node.getNodeName(), node.getNodeValue());
                }
                this.processRow(object, hashMap, arrayList);
            }
            for (String string : hashMap.keySet()) {
                if (arrayList.contains(string)) continue;
                throw new IllegalArgumentException("id not found:" + string);
            }
            this.clearAttributes();
        }
        catch (DocumentException documentException) {
            throw new IllegalStateException(documentException.getMessage());
        }
    }

    public void addFooter() throws IllegalStateException {
        this.addFooter(this.fFooterData);
    }

    public void addFooter(HashMap<String, String> hashMap) throws IllegalStateException {
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (this.fFooterTrs == null) {
                throw new IllegalStateException("footer is not found in the template");
            }
            for (int i = 0; i < this.fFooterTrs.getLength(); ++i) {
                org.w3c.dom.Element object = (org.w3c.dom.Element)this.fFooterTrs.item(i);
                this.fRowDefault = new HashMap();
                NamedNodeMap namedNodeMap = object.getAttributes();
                for (int j = 0; j < namedNodeMap.getLength(); ++j) {
                    Node node = namedNodeMap.item(j);
                    this.fRowDefault.put(node.getNodeName(), node.getNodeValue());
                }
                this.processRow(object, hashMap, arrayList);
            }
            for (String string : hashMap.keySet()) {
                if (arrayList.contains(string)) continue;
                throw new IllegalArgumentException("id not found:" + string);
            }
        }
        catch (DocumentException documentException) {
            throw new IllegalStateException(documentException.getMessage());
        }
    }

    public void newPage() throws IllegalStateException {
        try {
            this.fDocument.add((Element)this.fPdfTable);
            this.fDocument.newPage();
            this.beginTable();
        }
        catch (DocumentException documentException) {
            throw new IllegalStateException(documentException.getMessage());
        }
    }

    public void close() throws PdfException {
        try {
            this.fDocument.add((Element)this.fPdfTable);
            this.fDocument.close();
        }
        catch (DocumentException documentException) {
            throw new PdfException(documentException.getMessage());
        }
        catch (ExceptionConverter exceptionConverter) {
            throw new PdfException(exceptionConverter.getMessage());
        }
    }

    void processRow(org.w3c.dom.Element element, HashMap<String, String> hashMap, ArrayList<String> arrayList) throws DocumentException {
        NodeList nodeList = element.getElementsByTagName("td");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Object object;
            Object object2;
            org.w3c.dom.Element element2 = (org.w3c.dom.Element)nodeList.item(i).cloneNode(true);
            Object object3 = element2.getTextContent();
            String string = element2.getAttribute("id");
            if (!string.equals("")) {
                arrayList.add(string);
                object2 = hashMap.get(string);
                if (object2 != null) {
                    object3 = object2;
                }
                if ((object = this.fExtraAttributes.get(string)) != null) {
                    for (Map.Entry entry : ((HashMap)object).entrySet()) {
                        element2.setAttribute((String)entry.getKey(), (String)entry.getValue());
                    }
                }
            }
            object2 = new Cell();
            ((Cell)((Object)object2)).setTableDefault(this.fTableDefault);
            ((Cell)((Object)object2)).setRowDefault(this.fRowDefault);
            object = element2.getAttribute("colspan");
            int n = 1;
            if (!((String)object).equals("")) {
                n = Integer.parseInt((String)object);
                object2.setColspan(n);
            }
            boolean bl = false;
            int n2 = 1;
            String string2 = element2.getAttribute("rowspan");
            if (!string2.equals("")) {
                n2 = Integer.parseInt(string2);
                object2.setRowspan(n2);
            }
            ((Cell)((Object)object2)).setAttributes(element2);
            ((Cell)((Object)object2)).setContent((String)object3);
            this.fPdfTable.addCell((PdfPCell)object2);
        }
    }
}

