/*
 * Decompiled with CFR 0.152.
 */
package jp.veltec.pdf;

import com.itextpdf.text.DocumentException;
import com.itextpdf.text.pdf.BaseFont;
import java.io.IOException;
import java.util.HashMap;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class FontManager {
    static HashMap<String, BaseFont> fBaseFonts = new HashMap();
    static HashMap<String, BaseFont> fBaseFontsV = new HashMap();
    static String fDefaultFontPath;

    FontManager() {
    }

    static void init() {
        try {
            fBaseFonts.put("Times", BaseFont.createFont((String)"Times-Roman", (String)"Cp1252", (boolean)false));
            fBaseFonts.put("Helvetica", BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)false));
            fBaseFonts.put("Courier", BaseFont.createFont((String)"Courier", (String)"Cp1252", (boolean)false));
            fBaseFonts.put("Symbol", BaseFont.createFont((String)"Symbol", (String)"Cp1252", (boolean)true));
            fBaseFonts.put("Dingbats", BaseFont.createFont((String)"ZapfDingbats", (String)"Cp1252", (boolean)true));
            fBaseFonts.put("default", BaseFont.createFont((String)"HeiseiMin-W3", (String)"UniJIS-UCS2-H", (boolean)false));
            fBaseFontsV.put("default", BaseFont.createFont((String)"HeiseiMin-W3", (String)"UniJIS-UCS2-V", (boolean)false));
            fBaseFonts.put("\u660e\u671d", BaseFont.createFont((String)"HeiseiMin-W3", (String)"UniJIS-UCS2-H", (boolean)false));
            fBaseFontsV.put("\u660e\u671d", BaseFont.createFont((String)"HeiseiMin-W3", (String)"UniJIS-UCS2-V", (boolean)false));
            fBaseFonts.put("\u30b4\u30b7\u30c3\u30af", BaseFont.createFont((String)"HeiseiKakuGo-W5", (String)"UniJIS-UCS2-H", (boolean)false));
            fBaseFontsV.put("\u30b4\u30b7\u30c3\u30af", BaseFont.createFont((String)"HeiseiKakuGo-W5", (String)"UniJIS-UCS2-V", (boolean)false));
        }
        catch (DocumentException documentException) {
            documentException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void clearFonts() {
        fBaseFonts.clear();
        fBaseFontsV.clear();
        FontManager.init();
    }

    public static void register(NodeList nodeList) {
        try {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                BaseFont baseFont;
                BaseFont baseFont2;
                String string;
                Element element = (Element)nodeList.item(i);
                String string2 = "";
                String string3 = element.getAttribute("family");
                String string4 = element.getAttribute("path");
                boolean bl = true;
                if (!string4.equals("")) {
                    string2 = string2 + string4 + "/";
                } else if (fDefaultFontPath != null) {
                    string2 = string2 + fDefaultFontPath + "/";
                } else {
                    throw new IllegalArgumentException("Font Path not set");
                }
                String string5 = element.getAttribute("file");
                string2 = string2 + string5;
                String string6 = element.getAttribute("index");
                if (!string6.equals("")) {
                    string2 = string2 + "," + string6;
                }
                if (element.getAttribute("embedded").equals("no")) {
                    bl = false;
                    System.out.println("embedded:no");
                }
                if ((string = element.getAttribute("lang")).equals("jp")) {
                    baseFont2 = BaseFont.createFont((String)string2, (String)"Identity-H", (boolean)bl);
                    fBaseFonts.put(string3, baseFont2);
                    baseFont = BaseFont.createFont((String)string2, (String)"Identity-V", (boolean)bl);
                    fBaseFontsV.put(string3, baseFont);
                    continue;
                }
                baseFont2 = BaseFont.createFont((String)string2, (String)"Cp1252", (boolean)bl);
                fBaseFonts.put(string3, baseFont2);
                baseFont = BaseFont.createFont((String)string2, (String)"Cp1252", (boolean)bl);
                fBaseFontsV.put(string3, baseFont);
            }
        }
        catch (DocumentException documentException) {
            documentException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static BaseFont getBaseFont(String string) {
        BaseFont baseFont = fBaseFonts.get(string);
        if (baseFont == null) {
            throw new IllegalArgumentException("font-family not found:" + string);
        }
        return baseFont;
    }

    public static BaseFont getBaseFontV(String string) {
        BaseFont baseFont = fBaseFontsV.get(string);
        if (baseFont == null) {
            throw new IllegalArgumentException("font-family not found:" + string);
        }
        return baseFont;
    }

    public static void setDefaultFontPath(String string) {
        fDefaultFontPath = string;
    }

    static {
        FontManager.init();
    }
}

