/*
 * Decompiled with CFR 0.152.
 */
package jp.veltec.pdf;

import com.itextpdf.text.Chunk;
import com.itextpdf.text.Font;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPCell;
import java.util.HashMap;
import jp.veltec.pdf.FontManager;
import jp.veltec.pdf.Util;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class Cell
extends PdfPCell {
    HashMap<String, String> fAttributes = new HashMap();
    BaseFont bf = FontManager.getBaseFont("\u660e\u671d");
    Font fFont = new Font(this.bf, 12.0f);
    float fFontSize = 12.0f;
    float fLineHeight = 1.0f;
    float fCharacterSpacing = 0.0f;

    public void setTableDefault(HashMap<String, String> hashMap) {
        this.fAttributes.putAll(hashMap);
    }

    public void setRowDefault(HashMap<String, String> hashMap) {
        this.fAttributes.putAll(hashMap);
    }

    void setAttributes(Element element) {
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node = namedNodeMap.item(i);
            this.fAttributes.put(node.getNodeName(), node.getNodeValue());
        }
        String string = this.fAttributes.get("min-height");
        if (string != null) {
            this.setMinimumHeight(Util.getSize(string));
        }
        if ((string = this.fAttributes.get("height")) != null) {
            this.setFixedHeight(Util.getSize(string));
        }
        if ((string = this.fAttributes.get("align-h")) != null) {
            if (string.equals("center")) {
                this.setHorizontalAlignment(1);
            } else if (string.equals("right")) {
                this.setHorizontalAlignment(2);
            } else if (string.equals("left")) {
                this.setHorizontalAlignment(0);
            }
        }
        if ((string = this.fAttributes.get("align-v")) != null) {
            if (string.equals("middle")) {
                this.setVerticalAlignment(5);
            } else if (string.equals("bottom")) {
                this.setVerticalAlignment(6);
            } else if (string.equals("top")) {
                this.setVerticalAlignment(4);
            }
        }
        if ((string = this.fAttributes.get("font-family")) != null) {
            BaseFont baseFont = FontManager.getBaseFont(string);
            this.fFont = new Font(baseFont, this.fFontSize);
        }
        if ((string = this.fAttributes.get("font-style")) != null) {
            this.fFont.setStyle(string);
        }
        if ((string = this.fAttributes.get("font-size")) != null) {
            this.fFontSize = Util.getSize(string);
            this.fFont.setSize(this.fFontSize);
        }
        if ((string = this.fAttributes.get("font-color")) != null) {
            this.fFont.setColor(Util.getColor(string));
        }
        if ((string = this.fAttributes.get("background-color")) != null) {
            this.setBackgroundColor(Util.getColor(string));
        }
        if ((string = this.fAttributes.get("border-width")) != null) {
            this.setBorderWidthTop(Util.getSize(string));
            this.setBorderWidthBottom(Util.getSize(string));
            this.setBorderWidthLeft(Util.getSize(string));
            this.setBorderWidthRight(Util.getSize(string));
        }
        if ((string = this.fAttributes.get("border-width-top")) != null) {
            this.setBorderWidthTop(Util.getSize(string));
        }
        if ((string = this.fAttributes.get("border-width-bottom")) != null) {
            this.setBorderWidthBottom(Util.getSize(string));
        }
        if ((string = this.fAttributes.get("border-width-left")) != null) {
            this.setBorderWidthLeft(Util.getSize(string));
        }
        if ((string = this.fAttributes.get("border-width-right")) != null) {
            this.setBorderWidthRight(Util.getSize(string));
        }
        if ((string = this.fAttributes.get("border-color")) != null) {
            this.setBorderColor(Util.getColor(string));
        }
        if ((string = this.fAttributes.get("border-color-left")) != null) {
            this.setBorderColorLeft(Util.getColor(string));
        }
        if ((string = this.fAttributes.get("border-color-right")) != null) {
            this.setBorderColorRight(Util.getColor(string));
        }
        if ((string = this.fAttributes.get("border-color-top")) != null) {
            this.setBorderColorTop(Util.getColor(string));
        }
        if ((string = this.fAttributes.get("border-color-bottom")) != null) {
            this.setBorderColorBottom(Util.getColor(string));
        }
        if ((string = this.fAttributes.get("padding")) != null) {
            this.setPadding(Util.getSize(string));
        }
        if ((string = this.fAttributes.get("padding-left")) != null) {
            this.setPaddingLeft(Util.getSize(string));
        }
        if ((string = this.fAttributes.get("padding-right")) != null) {
            this.setPaddingRight(Util.getSize(string));
        }
        if ((string = this.fAttributes.get("padding-top")) != null) {
            this.setPaddingTop(Util.getSize(string));
        }
        if ((string = this.fAttributes.get("padding-bottom")) != null) {
            this.setPaddingBottom(Util.getSize(string));
        }
        if ((string = this.fAttributes.get("rotation")) != null) {
            if (string.equals("left")) {
                this.setRotation(90);
            } else if (string.equals("right")) {
                this.setRotation(270);
            } else if (string.equals("up")) {
                this.setRotation(0);
            } else if (string.equals("down")) {
                this.setRotation(180);
            }
        }
        if ((string = this.fAttributes.get("line-height")) != null) {
            this.setLeading(0.0f, Float.parseFloat(string));
        }
        if ((string = this.fAttributes.get("character-spacing")) != null) {
            this.fCharacterSpacing = Util.getSize(string);
        }
    }

    void setContent(String string) {
        string = string.replaceAll("\\\\n", "\n");
        Chunk chunk = new Chunk(string, this.fFont);
        chunk.setCharacterSpacing(this.fCharacterSpacing);
        this.setPhrase(new Phrase(chunk));
    }
}

